/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

public class SujetTraite extends Sujet {
    private RSSItem[] articles = new RSSItem[]{};
    private BaseRSSItem[] ressources = new BaseRSSItem[]{};

    public SujetTraite(int id, String titre) {
        super(id, titre);
    }

    public SujetTraite(SujetBrut base){
        super(base.getId(), base.getTitre());
        ressources = base.getArticles();
    }

    public RSSItem[] getArticles() {
        return articles;
    }

    public BaseRSSItem[] getRessources() {
        return ressources;
    }

    public void setArticles(RSSItem[] articles) {
        this.articles = articles;
    }

    @Override
    public int hashCode(){
        int n = 0;
        for(int i=0; i<articles.length; i++){
            n += articles[i].hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object o){
        return super.equals(o);
    }

    @Override
    public String toString(){
        String s = getTitre();
        if(s.contains(" - ")){
            String[] ss = s.split(" - ");
            s = "";
            for(int i=0; i<ss.length-1; i++){
                s += ss[i];
            }
        }
        return "[" + articles.length + " articles] " + s ;
    }
}
